/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModifierStatBoost {
    default public boolean matchesTags(ToolRebuildContext context) {
        for (class_6862<class_1792> key : this.tagRequirements()) {
            if (context.hasTag(key)) continue;
            return false;
        }
        return true;
    }

    public List<class_6862<class_1792>> tagRequirements();

    public void apply(ToolRebuildContext var1, float var2, ModifierStatsBuilder var3);

    public JsonObject toJson(JsonObject var1);

    default public JsonObject toJson() {
        return this.toJson(new JsonObject());
    }

    public void toNetwork(class_2540 var1);

    public static ModifierStatBoost fromJson(JsonObject json) {
        IToolStat<?> stat = ToolStats.fromJson(class_3518.method_15265((JsonObject)json, (String)"stat"));
        List<class_6862<class_1792>> tagRequirements = Collections.emptyList();
        if (json.has("tags")) {
            tagRequirements = JsonHelper.parseList(json, "tags", (element, name) -> class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)JsonHelper.convertToResourceLocation(element, name)));
        }
        if (stat instanceof INumericToolStat) {
            INumericToolStat numeric = (INumericToolStat)stat;
            return StatBoost.fromJson(json, numeric, tagRequirements);
        }
        return StatUpdate.fromJson(json, stat, tagRequirements);
    }

    public static ModifierStatBoost fromNetwork(class_2540 buffer) {
        IToolStat<?> stat = ToolStats.fromNetwork(buffer);
        ImmutableList.Builder tagRequirements = ImmutableList.builder();
        int size = buffer.method_10816();
        for (int i = 0; i < size; ++i) {
            tagRequirements.add((Object)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)buffer.method_10810()));
        }
        if (stat instanceof INumericToolStat) {
            INumericToolStat numeric = (INumericToolStat)stat;
            return StatBoost.fromNetwork(buffer, numeric, (List<class_6862<class_1792>>)tagRequirements.build());
        }
        return StatUpdate.fromNetwork(buffer, stat, (List<class_6862<class_1792>>)tagRequirements.build());
    }

    private static void serializeTags(JsonObject json, List<class_6862<class_1792>> tagRequirements) {
        if (!tagRequirements.isEmpty()) {
            JsonArray array = new JsonArray();
            for (class_6862<class_1792> tag : tagRequirements) {
                array.add(tag.comp_327().toString());
            }
            json.add("tags", (JsonElement)array);
        }
    }

    public record StatBoost(INumericToolStat<?> stat, BoostType type, float amount, List<class_6862<class_1792>> tagRequirements) implements ModifierStatBoost
    {
        @Override
        public void apply(ToolRebuildContext context, float level, ModifierStatsBuilder builder) {
            if (this.matchesTags(context)) {
                this.type.apply(builder, this.stat, this.amount, level);
            }
        }

        @Override
        public JsonObject toJson(JsonObject json) {
            json.addProperty("stat", this.stat.getName().toString());
            json.addProperty("operation", this.type.getName());
            json.addProperty("value", (Number)Float.valueOf(this.amount));
            ModifierStatBoost.serializeTags(json, this.tagRequirements);
            return json;
        }

        public static StatBoost fromJson(JsonObject json, INumericToolStat<?> stat, List<class_6862<class_1792>> tagRequirements) {
            String typeName = json.has("operation") ? class_3518.method_15265((JsonObject)json, (String)"operation") : class_3518.method_15253((JsonObject)json, (String)"type", (String)"add");
            BoostType boostType = BoostType.byName(typeName);
            if (boostType == null) {
                throw new JsonSyntaxException("Unknown stat operation '" + typeName + "'");
            }
            float amount = class_3518.method_15259((JsonObject)json, (String)"value");
            return new StatBoost(stat, boostType, amount, tagRequirements);
        }

        @Override
        public void toNetwork(class_2540 buffer) {
            buffer.method_10814(this.stat.getName().toString());
            buffer.method_10804(this.tagRequirements.size());
            for (class_6862<class_1792> key : this.tagRequirements) {
                buffer.method_10812(key.comp_327());
            }
            buffer.method_10817((Enum)this.type);
            buffer.writeFloat(this.amount);
        }

        public static StatBoost fromNetwork(class_2540 buffer, INumericToolStat<?> stat, List<class_6862<class_1792>> tagRequirement) {
            BoostType type = (BoostType)buffer.method_10818(BoostType.class);
            float amount = buffer.readFloat();
            return new StatBoost(stat, type, amount, tagRequirement);
        }
    }

    public record StatUpdate<T>(IToolStat<T> stat, T value, List<class_6862<class_1792>> tagRequirements) implements ModifierStatBoost
    {
        @Override
        public void apply(ToolRebuildContext context, float level, ModifierStatsBuilder builder) {
            this.stat.update(builder, this.value);
        }

        @Override
        public JsonObject toJson(JsonObject json) {
            json.addProperty("stat", this.stat.getName().toString());
            json.add("value", this.stat.serialize(this.value));
            ModifierStatBoost.serializeTags(json, this.tagRequirements);
            return json;
        }

        public static <T> StatUpdate<T> fromJson(JsonObject json, IToolStat<T> stat, List<class_6862<class_1792>> tagRequirements) {
            T value = stat.deserialize(JsonHelper.getElement(json, "value"));
            return new StatUpdate<T>(stat, value, tagRequirements);
        }

        @Override
        public void toNetwork(class_2540 buffer) {
            buffer.method_10814(this.stat.getName().toString());
            buffer.method_10804(this.tagRequirements.size());
            for (class_6862<class_1792> tag : this.tagRequirements) {
                buffer.method_10812(tag.comp_327());
            }
            this.stat.toNetwork(buffer, this.value);
        }

        public static <T> StatUpdate<T> fromNetwork(class_2540 buffer, IToolStat<T> stat, List<class_6862<class_1792>> tagRequirements) {
            T value = stat.fromNetwork(buffer);
            return new StatUpdate<T>(stat, value, tagRequirements);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BoostType {
        ADD{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value, float level) {
                stat.add(builder, value * level);
            }
        }
        ,
        MULTIPLY_BASE{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value, float level) {
                stat.multiply(builder, 1.0f + value * level);
            }
        }
        ,
        MULTIPLY_CONDITIONAL{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value, float level) {
                builder.multiplier(stat, 1.0f + value * level);
            }
        }
        ,
        MULTIPLY_ALL{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value, float level) {
                stat.multiplyAll(builder, 1.0f + value * level);
            }
        };

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public abstract void apply(ModifierStatsBuilder var1, INumericToolStat<?> var2, float var3, float var4);

        @Nullable
        public static BoostType byName(String name) {
            for (BoostType type : BoostType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

